﻿using MediatR;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllLoginAuditQueryHandler(
        ILoginAuditRepository _loginAuditRepository) : IRequestHandler<GetAllLoginAuditQuery, LoginAuditList>
    {
        public async Task<LoginAuditList> Handle(GetAllLoginAuditQuery request, CancellationToken cancellationToken)
        {
            return await _loginAuditRepository.GetLoginAudits(request.LoginAuditResource);
        }
    }
}
