﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllModuleCommandHandler(
        IModuleRepository _moduleRepository,
        IMapper _mapper) : IRequestHandler<GetAllModuleCommand, ServiceResponse<List<ModuleDto>>>
    {
        public async Task<ServiceResponse<List<ModuleDto>>> Handle(GetAllModuleCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entities = await _moduleRepository.All
                    .Include(c => c.Pages)
                    .ThenInclude(c => c.Actions.OrderBy(c => c.Order))
                    .OrderBy(c => c.Order).ToListAsync();
                var entityDtos = _mapper.Map<List<ModuleDto>>(entities);
                return ServiceResponse<List<ModuleDto>>.ReturnResultWith200(entityDtos);
            }
            catch (Exception ex)
            {
                return ServiceResponse<List<ModuleDto>>.Return500("error while Getting Modules");
            }

        }
    }
}
