﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;

public class AddLogCommandHandler(
    INLogRepository nLogRespository,
    IUnitOfWork<QMSDbContext> uow
    ) : IRequestHandler<AddLogCommand, ServiceResponse<NLogDto>>
{
    public async Task<ServiceResponse<NLogDto>> Handle(AddLogCommand request, CancellationToken cancellationToken)
    {
        nLogRespository.Add(new NLog
        {
            Id = Guid.NewGuid(),
            Logged = DateTime.UtcNow,
            Level = "Error",
            Message = request.ErrorMessage,
            Source = "Angular",
            Exception = request.Stack
        });

        await uow.SaveAsync(cancellationToken);
        return ServiceResponse<NLogDto>.ReturnSuccess();
    }
}
