﻿using MediatR;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetNLogsQueryHandler(
        INLogRepository _nLogRepository) : IRequestHandler<GetNLogsQuery, NLogList>
    {
        public async Task<NLogList> Handle(GetNLogsQuery request, CancellationToken cancellationToken)
        {
            return await _nLogRepository.GetNLogsAsync(request.NLogResource);
        }
    }
}