﻿using System;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class GetNcRateCommandHandler(
    INonConformanceRepository _nonConformanceRepository,
    IAuditRepository _auditRepository) : IRequestHandler<GetNcRateCommand, decimal>
{
    public async Task<decimal> Handle(GetNcRateCommand request, CancellationToken cancellationToken)
    {
        var totalNc = await _nonConformanceRepository.All.CountAsync();
        var totalAudit = await _auditRepository.All.CountAsync();
        if (totalAudit == 0 || totalNc == 0)
        {
            return 0;
        }
        decimal NcRate = Math.Round(((decimal)totalNc / totalAudit) * 100, 2);
        return NcRate;
    }
}
