﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Repository;
using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetNewNcNumberCommandHandler(INonConformanceRepository nonConformanceRepository) : IRequestHandler<GetNewNcNumberCommand, string>
    {

        public async Task<string> Handle(GetNewNcNumberCommand request, CancellationToken cancellationToken)
        {

            var lastNcNumber = await nonConformanceRepository
                    .All
                    .OrderByDescending(c => c.CreatedDate)
                    .FirstOrDefaultAsync();

            string prefix = "NC";
            int year = DateTime.UtcNow.Year;
            int nextNumber = 1;

            if (lastNcNumber?.NCNumber is string lastNumber)
            {
                var parts = lastNumber.Split('-');
                if (parts.Length == 3 && int.TryParse(parts[2], out int lastNum))
                {
                    nextNumber = lastNum + 1;
                }
            }
            return $"{prefix}-{year}-{nextNumber:D4}";

        }

    }
}

