﻿using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class GetNonconformanceResponseCommandHandler
    (INonConformanceRepository _nonConformanceRepository,
    IMapper _mapper,
    ILogger<GetNonconformanceResponseCommandHandler> _logger) : IRequestHandler<GetNonconformanceResponseCommand, ServiceResponse<NonConformanceDto>>
{
    public async Task<ServiceResponse<NonConformanceDto>> Handle(GetNonconformanceResponseCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var existEntity = await _nonConformanceRepository
                .All
                .Include(c => c.Department)
                .Include(c => c.ReportedBy)
                .Include(c => c.NonConformanceResponses)
                    .ThenInclude(c => c.ResponseType)
                .Include(c => c.NonConformanceResponses)
                    .ThenInclude(c => c.ResponsiblePerson)
                .Include(c => c.NonConformanceResponses)
                    .ThenInclude(c => c.VerifiedBy)
                .Include(c => c.NonConformanceResponses)
                .ThenInclude(c => c.NonConformanceRespAttachments)
                .Include(c => c.Audit)
                .Where(c => c.Id == request.Id).FirstOrDefaultAsync();
            if (existEntity == null)
            {
                return ServiceResponse<NonConformanceDto>.Return404("NonConformance not found");
            }

            var entityDto = _mapper.Map<NonConformanceDto>(existEntity);
            return ServiceResponse<NonConformanceDto>.ReturnResultWith200(entityDto);

        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while Get Nonconformance response");
            return ServiceResponse<NonConformanceDto>.Return500("Error while Getting Nonconformance response ");
        }


    }
}
