﻿using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;
using System;

namespace QualityManagement.MediatR
{
    public class UpdateNonConformanceCommand : IRequest<ServiceResponse<NonConformanceDto>>
    {
        public Guid Id { get; set; }
        public string Title { get; set; }
        public Guid ReportedById { get; set; }
        public Guid? DepartmentId { get; set; }
        public string Description { get; set; }
        public string NcNumber { get; set; }
        public NonConformanceSeverity Severity { get; set; }
        public NonConformanceStatus Status { get; set; }
        public DateTime? ClosedDate { get; set; }
        public Guid? AuditId { get; set; }

    }
}
