﻿using AutoMapper;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateNonConformanceCommandHandler(
        INonConformanceRepository _nonConformanceRepository,
        INonConformanceLogRepository _nonConformanceLogRepository,
        IMapper _mapper,
        ILogger<UpdateNonConformanceCommandHandler> _logger,
        IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<UpdateNonConformanceCommand, ServiceResponse<NonConformanceDto>>
    {
        public async Task<ServiceResponse<NonConformanceDto>> Handle(UpdateNonConformanceCommand request, CancellationToken cancellationToken)
        {

            try
            {
                var existEntity = await _nonConformanceRepository.FindAsync(request.Id);
                if (existEntity == null)
                {
                    return ServiceResponse<NonConformanceDto>.Return404("Nonconformance Not Found");
                }
                _mapper.Map(request, existEntity);
                var NcLog = _mapper.Map<NonConformanceLog>(existEntity);
                NcLog.Id = Guid.NewGuid();
                NcLog.LogStatus = LogStatus.Updated;

                _nonConformanceRepository.Update(existEntity);
                _nonConformanceLogRepository.Add(NcLog);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<NonConformanceDto>.Return500();
                }

                var entityDto = _mapper.Map<NonConformanceDto>(existEntity);
                return ServiceResponse<NonConformanceDto>.ReturnResultWith200(entityDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while updating NonConformance");
                return ServiceResponse<NonConformanceDto>.Return500("Error while updating NonConformance");
            }

        }
    }
}
