﻿using FluentValidation;
using System;

namespace QualityManagement.MediatR
{
    public class UpdateNonConformanceCommandValidator : AbstractValidator<UpdateNonConformanceCommand>
    {
        public UpdateNonConformanceCommandValidator()
        {
            RuleFor(c => c.Id).Must(NotEmptyGuid).WithMessage("Id is required");
        }
        private bool NotEmptyGuid(Guid p)
        {
            return p != Guid.Empty;
        }
    }
}
