﻿using FluentValidation;
using System;

namespace QualityManagement.MediatR
{
    public class AddNonConformanceRespAttachmentValidator : AbstractValidator<AddNonConformanceRespAttachmentCommand>
    {
        public AddNonConformanceRespAttachmentValidator()
        {
            RuleFor(c => c.NonConformanceResponseId).Must(NotGuidEmpty).WithMessage("NonConformanceResponse Id is required");
        }
        private bool NotGuidEmpty(Guid p)
        {
            return p != Guid.Empty;
        }
    }
}
