﻿using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using System;

namespace QualityManagement.MediatR
{
    public class AddNonConformanceResponseCommand : IRequest<ServiceResponse<NonConformanceResponseDto>>
    {
        public string Title { get; set; }
        public Guid NonConformanceId { get; set; }
        public Guid? NonConformanceResponseTypeId { get; set; }
        public string ResponseDescription { get; set; }
        public Guid? ResponsiblePersonId { get; set; }
        public DateTime? DueDate { get; set; }
        public DateTime? CompletionDate { get; set; }
        public bool IsEffective { get; set; }
        public Guid? VerifiedById { get; set; }
        public DateTime? VerificationDate { get; set; }
    }
}
