﻿using FluentValidation;
using System;

namespace QualityManagement.MediatR
{
    public class AddNonConformanceResponseCommandValidator : AbstractValidator<AddNonConformanceResponseCommand>
    {
        public AddNonConformanceResponseCommandValidator()
        {
            RuleFor(c => c.NonConformanceId).Must(NotEmptyGuid).WithMessage("NonConformance id is Required");
            RuleFor(c => c.ResponseDescription).NotEmpty().WithMessage("ResponseDescription is Required");
        }
        private bool NotEmptyGuid(Guid p)
        {
            return p != Guid.Empty;
        }

    }
}
