﻿using MediatR;
using Microsoft.AspNetCore.Hosting;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.MediatR;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteNonConformanceResponseAttachmentCommandHanler(
    INonConformanceRespAttachmentRepository _nonConformanceRespAttachmentRepository,
    INonConformanceResponseAttachmentChunkRepository _nonConformanceResponseAttachmentChunkRepository,
    IUnitOfWork<QMSDbContext> _uow,
    IStorageSettingRepository _storageSettingRepository,
    StorageServiceFactory _storageServiceFactory,
    IWebHostEnvironment _webHostEnvironment,
    PathHelper _pathHelper,
    ILogger<DeleteNonConformanceResponseAttachmentCommandHanler> _logger) : IRequestHandler<DeleteNonConformanceResponseAttachmentCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteNonConformanceResponseAttachmentCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var NcRespAttachment = await _nonConformanceRespAttachmentRepository.All
                .Where(c => c.Id == request.NonConformanceRespAttachmentId).FirstOrDefaultAsync();

                var NcChunk = await _nonConformanceResponseAttachmentChunkRepository
                    .All
                    .Where(c => c.NonConformanceRespAttachmentId == NcRespAttachment.Id).ToListAsync();
                
                if (NcChunk.Count() > 0)
                {
                    foreach (var documentChunk in NcChunk)
                    {
                        var storeageSetting = await _storageSettingRepository.GetStorageSettingByIdOrLocal(NcRespAttachment.StorageSettingId);
                        var storageService = _storageServiceFactory.GetStorageService(storeageSetting.StorageType);
                        await storageService.DeleteFileAsync(documentChunk.Url, storeageSetting.JsonValue);

                    }
                    _nonConformanceResponseAttachmentChunkRepository.RemoveRange(NcChunk);
                }
                _nonConformanceRespAttachmentRepository.Remove(NcRespAttachment);
                if (await _uow.SaveAsync(cancellationToken) <= 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "error while deleting NcResponceAttachment");
                return ServiceResponse<bool>.Return500("error while deleting NcResponceAttachment");
            }

        }
    }
}
