﻿using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteNonConformanceResponseCommandHandler(
        INonConformanceResponseRepository _nonConformanceResponseRepository,
        ILogger<DeleteNonConformanceResponseCommandHandler> _logger,
        IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<DeleteNonConformanceResponseCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteNonConformanceResponseCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var existEntity = await _nonConformanceResponseRepository.FindAsync(request.Id);
                if (existEntity == null)
                {
                    return ServiceResponse<bool>.Return404("NonConformanceResponse not found");
                }
                existEntity.IsDeleted = true;
                _nonConformanceResponseRepository.Update(existEntity);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while deleting NonConformanceResponse");
                return ServiceResponse<bool>.Return500("Error while deleting NonConformanceResponse");
            }
        }
    }

}