﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Helper;
using QualityManagement.Repository;
using QualityManagement.Repository.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DownloadNonConformanceRespAttachmenttChunkCommandHandler(
        IDocumentTokenRepository _documentTokenRepository,
        INonConformanceRespAttachmentRepository nonConformanceRespAttachmentRepository,
        INonConformanceResponseAttachmentChunkRepository _nonConformanceResponseAttachmentChunkRepository,
        ILogger<DownloadRiskAttachmentChunkCommandHandler> _logger,
        IMediator _mediator) : IRequestHandler<DownloadNonConformanceRespAttachmenttChunkCommand, ServiceResponse<DocumentDownload>>
    {
        public async Task<ServiceResponse<DocumentDownload>> Handle(DownloadNonConformanceRespAttachmenttChunkCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var isTokenFound = await _documentTokenRepository.All.AnyAsync(c => c.DocumentId == request.Id && c.Token == request.Token);
                if (!isTokenFound)
                {
                    return ServiceResponse<DocumentDownload>.Return404("Token not found");
                }
                var ncResponseAttachment = await nonConformanceRespAttachmentRepository.All.Where(c => c.Id == request.Id).FirstOrDefaultAsync();
                if (ncResponseAttachment == null)
                {
                    return ServiceResponse<DocumentDownload>.Return404("non Conformance response attachment not found");
                }
                var ncResponseAttachmenttChunks = await _nonConformanceResponseAttachmentChunkRepository.All.Where(c => c.NonConformanceRespAttachmentId == ncResponseAttachment.Id).OrderBy(c => c.ChunkIndex).ToListAsync();
                if (ncResponseAttachmenttChunks.Count <= 0)
                {
                    return ServiceResponse<DocumentDownload>.Return404("non Conformance response attachment chunk not found");
                }
                var chunks = ncResponseAttachmenttChunks.Select(c => new FileChunk
                {
                    ChunkIndex = c.ChunkIndex,
                    Url = c.Url,
                }).ToList();
                var fileDownloadRequestCommand = new FileDownloadRequestCommand
                {
                    StorageSettingId = ncResponseAttachment.StorageSettingId,
                    Key = ncResponseAttachment.Key,
                    IV = ncResponseAttachment.IV,
                    Extension = ncResponseAttachment.Extension,
                    Chunks = chunks,
                    FileName = ncResponseAttachment.FileName,
                };
                var result = await _mediator.Send(fileDownloadRequestCommand);
                return result;
            }
            catch (Exception ex)
            {
                _logger.LogError(ex, "error while getting non Conformance Response attachment");
                return ServiceResponse<DocumentDownload>.Return500("An unexpected fault happened. Try again later. ");
            }
        }
    }
}
