﻿using FluentValidation;
using System;

namespace QualityManagement.MediatR
{
    public class MarkAttachmentChunksUploadedCommandValidator : AbstractValidator<MarkAttachmentChunksUploadedCommand>
    {
        public MarkAttachmentChunksUploadedCommandValidator()
        {
            RuleFor(c => c.NonConformanceRespAttachmentId).Must(NotGuidEmpty).WithMessage("NonConformanceRespAttachment Id is required");
            RuleFor(c => c.Status).NotEmpty().WithMessage("status is required");
        }
        private bool NotGuidEmpty(Guid p)
        {
            return p != Guid.Empty;
        }
    }
}
