﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllNonConformanceResponseTypeCommandHandler(
        INonConformanceResponseTypeRepository _nonConformanceResponseTypeRepository,
        IMapper _mapper,
        ILogger<GetAllNonConformanceResponseTypeCommandHandler> _logger)
        : IRequestHandler<GetAllNonConformanceResponseTypeCommand, ServiceResponse<List<NonConformanceResponseTypeDto>>>
    {
        public async Task<ServiceResponse<List<NonConformanceResponseTypeDto>>> Handle(GetAllNonConformanceResponseTypeCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entities = await _nonConformanceResponseTypeRepository.All.ToListAsync();
                var entitiesDto = _mapper.Map<List<NonConformanceResponseTypeDto>>(entities);
                return ServiceResponse<List<NonConformanceResponseTypeDto>>.ReturnResultWith200(entitiesDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error get all NonConformanceTypeResponse");
                return ServiceResponse<List<NonConformanceResponseTypeDto>>.Return500();
            }

        }
    }
}
