﻿using AutoMapper;
using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetPageHelperCommandHandler(
        IPageHelperRepository _pageHelperRepository,
        IMapper _mapper) : IRequestHandler<GetPageHelperCommand, ServiceResponse<PageHelperDto>>
    {
        public async Task<ServiceResponse<PageHelperDto>> Handle(GetPageHelperCommand request, CancellationToken cancellationToken)
        {
            var entity = await _pageHelperRepository.FindAsync(request.Id);
            if (entity != null)
            {
                var dto = _mapper.Map<PageHelperDto>(entity);
                return ServiceResponse<PageHelperDto>.ReturnResultWith200(dto);
            }
            return ServiceResponse<PageHelperDto>.Return404("Page Helper not found");
        }
    }
}
