﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class GetAllPageQueryHandler(
    IPageRepository pageRepository,
    IMapper mapper) : IRequestHandler<GetAllPageQuery, List<PageDto>>
{
    public async Task<List<PageDto>> Handle(GetAllPageQuery request, CancellationToken cancellationToken)
    {
        var entities = await pageRepository.All.OrderBy(c => c.Order).ToListAsync(cancellationToken);
        return mapper.Map<List<PageDto>>(entities);
    }
}
