﻿using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetAllRecentDocumentQueryHandler(IRecentDocumentRepository _recentDocumentRepository) : IRequestHandler<GetAllRecentDocumentQuery, RecentDocumentList>
{
    public async Task<RecentDocumentList> Handle(GetAllRecentDocumentQuery request, CancellationToken cancellationToken)
    {
        return await _recentDocumentRepository.GetRecentDocuments(request.DocumentResource);
    }
}
