﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Linq;
using System.Linq.Dynamic.Core;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class CheckReminderByDocumentCommandHandler(
        IReminderRepository _reminderRepository,
        UserInfoToken _userInfo) : IRequestHandler<CheckReminderByDocumentCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(CheckReminderByDocumentCommand request, CancellationToken cancellationToken)
        {
            var flag = await _reminderRepository.All.AnyAsync(c => c.DocumentId == request.DocumentId && c.ReminderUsers.Any(ru => ru.UserId == _userInfo.Id));
            return ServiceResponse<bool>.ReturnResultWith200(flag);
        }
    }
}
