﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteReminderCurrentUserCommandHandler(
        IReminderRepository _reminderRepository,
         IReminderUserRepository _reminderUserRepository,
         IUnitOfWork<QMSDbContext> _uow,
         UserInfoToken _userInfoToken) : IRequestHandler<DeleteReminderCurrentUserCommand, ServiceResponse<bool>>
    {

        public async Task<ServiceResponse<bool>> Handle(DeleteReminderCurrentUserCommand request, CancellationToken cancellationToken)
        {
            var reminder = await _reminderRepository.FindAsync(request.Id);
            if (reminder == null)
            {
                return ServiceResponse<bool>.Return404();
            }

            var reminserUser = await _reminderUserRepository.FindBy(c => c.ReminderId == request.Id && c.UserId == _userInfoToken.Id)
                                .FirstOrDefaultAsync();

            if (reminserUser != null)
            {
                _reminderUserRepository.Remove(reminserUser);
            }
            else
            {
                return ServiceResponse<bool>.Return404();
            }
            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<bool>.Return500();
            }

            return ServiceResponse<bool>.ReturnSuccess();
        }
    }
}
