﻿using MediatR;
using QualityManagement.Data;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllReminderNotificationQueryHandler(
        IReminderSchedulerRepository _reminderSchedulerRepository) : IRequestHandler<GetAllReminderNotificationQuery, PagedList<ReminderScheduler>>
    {
        public async Task<PagedList<ReminderScheduler>> Handle(GetAllReminderNotificationQuery request, CancellationToken cancellationToken)
        {
            return await _reminderSchedulerRepository.GetReminders(request.ReminderResource);
        }
    }
}
