﻿using MediatR;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllReminderQueryHandler(
         IReminderRepository _reminderRepository) : IRequestHandler<GetAllReminderQuery, ReminderList>
    {
        public async Task<ReminderList> Handle(GetAllReminderQuery request, CancellationToken cancellationToken)
        {
            return await _reminderRepository.GetReminders(request.ReminderResource);
        }
    }
}
