﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetReminderByIdQueryHandler(
        IReminderRepository _reminderRepository,
        IMapper _mapper) : IRequestHandler<GetReminderByIdQuery, ServiceResponse<ReminderDto>>
    {
        public async Task<ServiceResponse<ReminderDto>> Handle(GetReminderByIdQuery request, CancellationToken cancellationToken)
        {
            var reminder = await _reminderRepository
                .AllIncluding(cs => cs.ReminderUsers, c => c.DailyReminders, c => c.QuarterlyReminders, c => c.HalfYearlyReminders).FirstOrDefaultAsync(c => c.Id == request.Id);

            if (reminder == null)
                return ServiceResponse<ReminderDto>.Return404();

            return ServiceResponse<ReminderDto>.ReturnResultWith200(_mapper.Map<ReminderDto>(reminder));
        }
    }
}

