﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetTop10ReminderNotificationQueryHandler(
        IReminderSchedulerRepository _reminderSchedulerRepository,
        UserInfoToken _userInfoToken,
        IMapper _mapper) : IRequestHandler<GetTop10ReminderNotificationQuery, List<ReminderSchedulerDto>>
    {

        public async Task<List<ReminderSchedulerDto>> Handle(GetTop10ReminderNotificationQuery request, CancellationToken cancellationToken)
        {
            var reminderSchedulers = await _reminderSchedulerRepository.All.Where(c => !c.IsRead && c.UserId == _userInfoToken.Id)
                                    .OrderBy(c => c.CreatedDate)
                                    .Take(10)
                                    .ToListAsync();

            return _mapper.Map<List<ReminderSchedulerDto>>(reminderSchedulers);
        }
    }
}
