﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Helper;
using QualityManagement.Repository.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class GetAllAsignRiskCommandHandler(
        IRiskRepository _riskRepository,
        IMapper _mapper,
        ILogger<GetRiskCommandHandler> _logger,
        UserInfoToken _userInfoToken) : IRequestHandler<GetAllAsignRiskCommand, ServiceResponse<List<RiskDto>>>
    {
        public async Task<ServiceResponse<List<RiskDto>>> Handle(GetAllAsignRiskCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var userId = _userInfoToken.Id;

                var entity = await _riskRepository.All
                    .Where(r =>
                        r.AssignedToId == userId ||
                        r.RiskReviews.Any(rr => rr.ReviewerId == userId) ||
                        r.RiskControls.Any(rc => rc.ResponsibleId == userId))
                    .Include(r => r.CreatedUser)
                    .Include(r => r.RiskCategory)
                    .Include(r => r.AssignedTo)
                    .Include(r => r.RiskReviews.Where(rr => rr.ReviewerId == userId))
                        .ThenInclude(rr => rr.Reviewer)
                    .Include(r => r.RiskControls.Where(rc => rc.ResponsibleId == userId))
                        .ThenInclude(rc => rc.ResponsibleBy)
                    .Include(r => r.RiskAttachments)
                    .ToListAsync();

                var entityDtos = _mapper.Map<List<RiskDto>>(entity);
                return ServiceResponse<List<RiskDto>>.ReturnResultWith201(entityDtos);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while getting asign Risks");
                return ServiceResponse<List<RiskDto>>.Return500("Error while getting asign Risk");
            }
        }
    }
}
