﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Helper;
using QualityManagement.Repository;
using QualityManagement.Repository.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class GetAllRiskAttachmentCommandHandler(
        IRiskAttachmentRepository _riskAttachmentRepository,
        IMapper _mapper,
        ILogger<GetAllRiskAttachmentCommandHandler> _logger) : IRequestHandler<GetAllRiskAttachmentCommand, ServiceResponse<List<RiskAttachmentDto>>>
    {
        public async Task<ServiceResponse<List<RiskAttachmentDto>>> Handle(GetAllRiskAttachmentCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entity = await _riskAttachmentRepository.All.Where(d => d.RiskId == request.RiskId).ToListAsync();
                var entityDto = _mapper.Map<List<RiskAttachmentDto>>(entity);
                return ServiceResponse<List<RiskAttachmentDto>>.ReturnResultWith201(entityDto);
            }
            catch (Exception ex)
            {
                _logger.LogError(ex, "Error occurred while getting Risk attachment by capa request ID: {CapaRequestId}", request.RiskId);
                return ServiceResponse<List<RiskAttachmentDto>>.Return500("An error occurred while processing the request.");
            }
        }
    }
}
