﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class GetAllRiskCategoryCommandHandler(
        IRiskCategoryRepository _riskCategoryRepository,
        IMapper _mapper,
        ILogger<GetAllRiskCategoryCommandHandler> _logger) : IRequestHandler<GetAllRiskCategoryCommand, ServiceResponse<List<RiskCategoryDto>>>
    {
        public async Task<ServiceResponse<List<RiskCategoryDto>>> Handle(GetAllRiskCategoryCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entities = await _riskCategoryRepository.All.ToListAsync(cancellationToken);
                var entityDto = _mapper.Map<List<RiskCategoryDto>>(entities);
                return ServiceResponse<List<RiskCategoryDto>>.ReturnResultWith200(entityDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while Get all riskCategory");
                return ServiceResponse<List<RiskCategoryDto>>.Return500("Error while Get all riskCategory");
            }
        }
    }
}
