﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateRiskCategoryCommandHandler(
        IRiskCategoryRepository _riskCategoryRepository,
        IMapper _mapper,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<UpdateRiskCategoryCommandHandler> _logger) : IRequestHandler<UpdateRiskCategoryCommand, ServiceResponse<RiskCategoryDto>>
    {
        public async Task<ServiceResponse<RiskCategoryDto>> Handle(UpdateRiskCategoryCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entityExit = await _riskCategoryRepository.All.FirstOrDefaultAsync(c => c.Id == request.Id);
                if (entityExit == null)
                {
                    return ServiceResponse<RiskCategoryDto>.Return404("Risk Category not found");
                }

                var existingEntity = await _riskCategoryRepository.All
                  .Where(c => c.Id != request.Id && c.Name.ToLower() == request.Name.ToLower()).FirstOrDefaultAsync();
                if (existingEntity != null)
                {
                    return ServiceResponse<RiskCategoryDto>.Return409("RiskCategory name is already exist");
                }
                var entity = _mapper.Map(request,entityExit);
                _riskCategoryRepository.Update(entity);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<RiskCategoryDto>.Return500();
                }
                var entityDto = _mapper.Map<RiskCategoryDto>(entity);
                return ServiceResponse<RiskCategoryDto>.ReturnResultWith200(entityDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while updating RiskCategory");
                return ServiceResponse<RiskCategoryDto>.Return500("Error while saving RiskCategory");

            }

        }
    }
}
