﻿using FluentValidation;
using System;

namespace QualityManagement.MediatR.RiskManagement
{
    public class UpdateRiskCategoryCommandValidator : AbstractValidator<UpdateRiskCategoryCommand>
    {
        public UpdateRiskCategoryCommandValidator()
        {
            RuleFor(c => c.Id).Must(GuidNotEmpty).WithMessage("riskCategory id is required");
            RuleFor(c => c.Name).NotEmpty().WithMessage("name is required");
        }
        private bool GuidNotEmpty(Guid p)
        {
            return p != Guid.Empty;
        }
    }
}
