﻿using Amazon.Runtime.Internal.Util;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Helper;
using QualityManagement.Repository.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class GetAllRiskControlHandler(
        IRiskControlRepository _riskControlRepository,
        IMapper _mapper,
        ILogger<GetAllRiskControlHandler> _logger) : IRequestHandler<GetAllRiskControl, ServiceResponse<List<RiskControlDto>>>
    {
        public async Task<ServiceResponse<List<RiskControlDto>>> Handle(GetAllRiskControl request, CancellationToken cancellationToken)
        {
            try
            {
                var entities = await _riskControlRepository
                    .All
                    .Include(c=>c.ResponsibleBy)
                    .Where(c => c.RiskId == request.RiskId).ToListAsync();

                var entitiesDto = _mapper.Map<List<RiskControlDto>>(entities);
                return ServiceResponse<List<RiskControlDto>>.ReturnResultWith201(entitiesDto);
            }
            catch (Exception ex) 
            {
                _logger.LogError(ex,"Error while Getting A RiskControles");
                return ServiceResponse<List<RiskControlDto>>.Return500("Error while Getting A RiskControles");
            }
            }
    }
}
