﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class UpdateRiskControlCommandValidator:AbstractValidator<UpdateRiskControlCommand>
    {
        public UpdateRiskControlCommandValidator()
        {
            RuleFor(c => c.Id).Must(GuidNotEmpty).WithMessage(" id is required");
            RuleFor(c => c.RiskId).Must(GuidNotEmpty).WithMessage("Risk id is required");
            RuleFor(c => c.ResponsibleId).Must(GuidNotEmpty).WithMessage("Responsible Person id is required");
            RuleFor(c => c.Title).NotEmpty().WithMessage("title is required");
            //RuleFor(c => c.ImplementationDate).GreaterThanOrEqualTo(DateTime.Today).WithMessage("ImplementationDate must be today or in the future");
        }
        private bool GuidNotEmpty(Guid p)
        {
            return p != Guid.Empty;
        }
    }
}
