﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Helper;
using QualityManagement.Repository.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class GetAllRiskReviewCommandHandler(
        IRiskReviewRepository _riskReviewRepository,
        IMapper _mapper,
        ILogger<GetAllRiskReviewCommandHandler> _logger) : IRequestHandler<GetAllRiskReviewCommand, ServiceResponse<List<RiskReviewDto>>>
    {
        public async Task<ServiceResponse<List<RiskReviewDto>>> Handle(GetAllRiskReviewCommand request, CancellationToken cancellationToken)
        {
            try
            {

                var entities = await _riskReviewRepository.All.
                    Include(c=>c.Reviewer).Where(c=>c.RiskId==request.RiskId).ToListAsync();
                var entitiesDto = _mapper.Map<List<RiskReviewDto>>(entities);
                return ServiceResponse<List<RiskReviewDto>>.ReturnResultWith200(entitiesDto);
                
            }
            catch (System.Exception ex) 
            {
                _logger.LogError(ex,"Error while getting RiskReviews");
                return ServiceResponse<List<RiskReviewDto>>.Return500("Error while gettingg RiskReviews");
            }
        }
    }
}
