﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.RiskManagement
{
    public class UpdateRiskReviewCommandValidator:AbstractValidator<UpdateRiskReviewCommand>
    {
        public UpdateRiskReviewCommandValidator()
        {
            RuleFor(c => c.Id).Must(GuidNotEmpty).WithMessage("Id is required");
            RuleFor(c => c.RiskId).Must(GuidNotEmpty).WithMessage("risk id id required");
            RuleFor(c => c.ReviewerComments).NotEmpty().WithMessage("ReviewerComments is required");
            RuleFor(c => c.Likelihood).InclusiveBetween(1, 5).WithMessage("likelihood must be between 1 and 5");
            RuleFor(c => c.Impact).InclusiveBetween(1, 5).WithMessage("Impact must be between 1 and 5");
        }
        private bool GuidNotEmpty(Guid p)
        {
            return p != Guid.Empty;
        }
    }
}
