﻿using MediatR;
using Microsoft.AspNetCore.Identity;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteRoleCommandHandler(
        RoleManager<Role> _roleManger,
        IUserRoleRepository _userRoleRepository) : IRequestHandler<DeleteRoleCommand, RoleDto>
    {

        public async Task<RoleDto> Handle(DeleteRoleCommand request, CancellationToken cancellationToken)
        {
            var entityExist = await _roleManger.FindByIdAsync(request.Id.ToString());
            if (entityExist == null)
            {
                var errorDto = new RoleDto
                {
                    StatusCode = 404,
                    Messages = new List<string> { "Not Found Role" }
                };
                return errorDto;
            }
            int roleCount = await  _roleManger.Roles.CountAsync();
            if (roleCount <= 1)
            {
                var errorDto = new RoleDto
                {
                    StatusCode = 409,
                    Messages = new List<string> { "Last remaining role cannot be deleted." }
                };
                return errorDto;
            }
            entityExist.IsDeleted = true;
            IdentityResult result = await _roleManger.UpdateAsync(entityExist);

            await _userRoleRepository.All.Where(c => c.RoleId == request.Id).ExecuteDeleteAsync();

            if (!result.Succeeded)
            {
                var errorDto = new RoleDto
                {
                    StatusCode = 500,
                    Messages = new List<string> { "An unexpected fault happened. Try again later." }
                };
                return errorDto;
            }
            return new RoleDto
            {
                StatusCode = 200,
                Messages = new List<string> { "Role deleted successfully." }
            };
        }
    }
}
