﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllRoleQueryHandler(
        IRoleRepository _roleRepository,
        IMapper _mapper) : IRequestHandler<GetAllRoleQuery, List<RoleDto>>
    {
        public async Task<List<RoleDto>> Handle(GetAllRoleQuery request, CancellationToken cancellationToken)
        {
            var entities = await _roleRepository.All.ToListAsync();
            return _mapper.Map<List<RoleDto>>(entities);
        }
    }
}
