﻿using MediatR;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteStorageSettingCommandHandler(
        IUnitOfWork<QMSDbContext> _uow,
         IStorageSettingRepository _storageSettingRepository) : IRequestHandler<DeleteStorageSettingCommand, ServiceResponse<bool>>
    {

        public async Task<ServiceResponse<bool>> Handle(DeleteStorageSettingCommand request, CancellationToken cancellationToken)
        {
            var storageSetting = await _storageSettingRepository.FindAsync(request.Id);
            if (storageSetting == null)
            {
                return ServiceResponse<bool>.Return404();
            }
            storageSetting.IsDeleted = true;
            _storageSettingRepository.Delete(storageSetting);
            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            return ServiceResponse<bool>.ReturnResultWith200(true);
        }
    }
}
