﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic.Core;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllStorageSettingCommandHandler(
        IStorageSettingRepository _storageSettingRepository,
        IMapper _mapper) : IRequestHandler<GetAllStorageSettingQuery, List<StorageSettingDto<string>>>
    {
        public async Task<List<StorageSettingDto<string>>> Handle(GetAllStorageSettingQuery request, CancellationToken cancellationToken)
        {
            var entities = await _storageSettingRepository.All.Where(setting => setting.IsDeleted == false).ToListAsync(cancellationToken);
            return _mapper.Map<List<StorageSettingDto<string>>>(entities);
        }
    }
}
