﻿using MediatR;
using Newtonsoft.Json;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    // Renamed the class to match the Query naming convention
    public class GetStorageSettingQueryHandler(
        IStorageSettingRepository _storageSettingRepository) : IRequestHandler<GetStorageSettingQuery, ServiceResponse<StorageSettingDto<object>>>
    {

        public async Task<ServiceResponse<StorageSettingDto<object>>> Handle(GetStorageSettingQuery request, CancellationToken cancellationToken)
        {
            var entity = await _storageSettingRepository.FindAsync(request.Id);

            if (entity == null)
            {
                return ServiceResponse<StorageSettingDto<object>>.Return409("Not found");
            }

            // Handle potential null or invalid JsonValue
            object jsonValue = null;
            if (!string.IsNullOrWhiteSpace(entity.JsonValue))
            {
                try
                {
                    jsonValue = JsonConvert.DeserializeObject<object>(entity.JsonValue);
                }
                catch (JsonException)
                {
                    return ServiceResponse<StorageSettingDto<object>>.Return409("Invalid JSON format in storage setting.");
                }
            }

            // Map entity to DTO
            var storageSetting = new StorageSettingDto<object>
            {
                Id = entity.Id,
                IsDefault = entity.IsDefault,
                EnableEncryption = entity.EnableEncryption,
                JsonValue = jsonValue,
                Name = entity.Name,
                StorageType = entity.StorageType
            };

            return ServiceResponse<StorageSettingDto<object>>.ReturnResultWith200(storageSetting);
        }
    }
}
