﻿using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class AddSupplierCommandHandler(
   ISupplierRepository _supplierRepository,
   IMapper _mapper,
   IUnitOfWork<QMSDbContext> _uow,
   ILogger<AddSupplierCommandHandler> _logger) : IRequestHandler<AddSupplierCommand, ServiceResponse<SupplierDto>>
{
    public async Task<ServiceResponse<SupplierDto>> Handle(AddSupplierCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var existEntity = await _supplierRepository.All
            .Where(c => c.Name == request.Name)
            .FirstOrDefaultAsync();
            if (existEntity != null)
            {
                return ServiceResponse<SupplierDto>.Return409("Supplier with same name already exists.");
            }
            var entity = _mapper.Map<Supplier>(request);
            entity.SupplierCode = await _supplierRepository.GenerateSupplierNumberAsync();
            _supplierRepository.Add(entity);
            if (await _uow.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<SupplierDto>.Return500();
            }
            var entityDto = _mapper.Map<SupplierDto>(entity);
            return ServiceResponse<SupplierDto>.ReturnResultWith201(entityDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Erorr while saving Supplier");
            return ServiceResponse<SupplierDto>.Return500("Error while Saving Supplier");
        }
    }
}
