﻿using FluentValidation;

namespace QualityManagement.MediatR;
public class AddSupplierCommandValidator : AbstractValidator<AddSupplierCommand>
{
    public AddSupplierCommandValidator()
    {
        RuleFor(c => c.Name).NotEmpty().WithMessage("Name is required");
        RuleFor(c => c.ContactPerson).NotEmpty().WithMessage("ContactPerson is required");
        RuleFor(c => c.Email).EmailAddress().When(c => !string.IsNullOrEmpty(c.Email)).WithMessage("Email must be in the correct format.");
        RuleFor(c => c.Phone).NotEmpty().When(c => string.IsNullOrEmpty(c.Email)).WithMessage("Either Phone or Email is required.");
        RuleFor(c => c.Email).NotEmpty().When(c => string.IsNullOrEmpty(c.Phone)).WithMessage("Either Email or Phone is required.");
        RuleFor(c => c.Status)
            .IsInEnum()
            .WithMessage("Status must be a valid enum value.");

    }
}
