﻿using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class DeleteSupplierCommandHandler(
    ISupplierRepository supplierRepository,
    ILogger<DeleteSupplierCommandHandler> logger,
    IUnitOfWork<QMSDbContext> unitOfWork) : IRequestHandler<DeleteSupplierCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(DeleteSupplierCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var course = await supplierRepository.FindAsync(request.Id);
            if (course == null)
            {
                return ServiceResponse<bool>.Return404();
            }
            supplierRepository.Delete(course);
            if (await unitOfWork.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            return ServiceResponse<bool>.ReturnResultWith204();
        }
        catch (System.Exception ex)
        {
            logger.LogError(ex, "Error while deleting supplier");
            return ServiceResponse<bool>.Return500("Error while deleting supplier");
        }
    }
}
