﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetSupplierAuditCommandHandler(
    ISupplierAuditRepository supplierAuditRepository,
    ILogger<GetSupplierAuditCommandHandler> _logger,
    IMapper mapper) : IRequestHandler<GetSupplierAuditCommand, ServiceResponse<List<SupplierAuditDto>>>
{
    public async Task<ServiceResponse<List<SupplierAuditDto>>> Handle(GetSupplierAuditCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var entities = await supplierAuditRepository
                .All
                .Include(c => c.Auditor)
                .Where(c => c.SupplierId == request.Id)
                .ToListAsync();
            var entitiesDto = mapper.Map<List<SupplierAuditDto>>(entities);
            return ServiceResponse<List<SupplierAuditDto>>.ReturnResultWith200(entitiesDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while getting CapaReview");
            return ServiceResponse<List<SupplierAuditDto>>.Return500("Error while getting CapaReview");
        }
    }
}
