﻿using System;
using MediatR;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;

namespace QualityManagement.MediatR;
public class AddSupplierCertificationCommand : IRequest<ServiceResponse<SupplierCertificationDto>>
{
    public Guid SupplierId { get; set; } // Foreign key to Supplier
    public string CertificationName { get; set; } // Name of the certification
    public string IssuedBy { get; set; } // Organization that issued the certification
    public DateTime IssuedDate { get; set; } // Date when the certification was issued
    public DateTime? ExpiryDate { get; set; } // Date when the certification expires
    public string CertificationNumber { get; set; } // Unique identifier for the certification
    public string Status { get; set; } // Status of the certification (e.g., Active, Expired, Revoked)
    public string FilePath { get; set; }
    public string FileName { get; set; }
    [FromForm]
    public IFormFile File { get; set; }
}
