﻿using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class DeleteSupplierCertificationCommandHandler(
    ISupplierCertificationRepository supplierCertificationRepository,
    ILogger<DeleteSupplierCertificationCommand> logger,
    IUnitOfWork<QMSDbContext> unitOfWork) : IRequestHandler<DeleteSupplierCertificationCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(DeleteSupplierCertificationCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var supplierCertification = await supplierCertificationRepository.FindAsync(request.Id);
            if (supplierCertification == null)
            {
                return ServiceResponse<bool>.Return404();
            }
            supplierCertificationRepository.Remove(supplierCertification);
            if (await unitOfWork.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            return ServiceResponse<bool>.ReturnResultWith204();
        }
        catch (System.Exception ex)
        {
            logger.LogError(ex, "Error while deleting supplierCertification");
            return ServiceResponse<bool>.Return500("Error while deleting supplierCertification");
        }
    }
}
