﻿using DocumentFormat.OpenXml.Drawing;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Mscc.GenerativeAI;
using QualityManagement.Helper;
using QualityManagement.Repository;
using QualityManagement.Repository.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DownloadSupplierCertificationChunkCommandHandler(
        IDocumentTokenRepository _documentTokenRepository,
        ISupplierCertificationRepository supplierCertificationRepository,
        ILogger<DownloadRiskAttachmentChunkCommandHandler> _logger,
        IMediator _mediator) : IRequestHandler<DownloadSupplierCertificationChunkCommand, ServiceResponse<DocumentDownload>>
    {
        public async Task<ServiceResponse<DocumentDownload>> Handle(DownloadSupplierCertificationChunkCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var isTokenFound = await _documentTokenRepository.All.AnyAsync(c => c.DocumentId == request.Id && c.Token == request.Token);
                if (!isTokenFound)
                {
                    return ServiceResponse<DocumentDownload>.Return404("Token not found");
                }
                var supplierCertification = await supplierCertificationRepository.All.Where(c => c.Id == request.Id).FirstOrDefaultAsync();
                if (supplierCertification == null)
                {
                    return ServiceResponse<DocumentDownload>.Return404("supplier certification not found");
                }

                var chunks = new List<FileChunk>
                { new FileChunk
                {
                     ChunkIndex = 0,
                    Url = supplierCertification.FilePath,
                } }.ToList();

                string extension = System.IO.Path.GetExtension(supplierCertification.FilePath);
                var fileDownloadRequestCommand = new FileDownloadRequestCommand
                {
                    StorageSettingId = null,
                    Key = null,
                    IV = null,
                    Extension = extension,
                    Chunks = chunks,
                    FileName = supplierCertification.FileName,
                };
                var result = await _mediator.Send(fileDownloadRequestCommand);
                return result;
            }
            catch (Exception ex)
            {
                _logger.LogError(ex, "error while getting supplier certification");
                return ServiceResponse<DocumentDownload>.Return500("An unexpected fault happened. Try again later. ");
            }
        }
    }
}
