﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetSupplierCertificationCommandHandler(
    ISupplierCertificationRepository supplierCertificationRepository,
    ILogger<GetSupplierCertificationCommandHandler> _logger,
    IMapper mapper) : IRequestHandler<GetSupplierCertificationCommand, ServiceResponse<List<SupplierCertificationDto>>>
{
    public async Task<ServiceResponse<List<SupplierCertificationDto>>> Handle(GetSupplierCertificationCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var entities = await supplierCertificationRepository
                .All
                .Where(c => c.SupplierId == request.Id)
                .ToListAsync();
            var entitiesDto = mapper.Map<List<SupplierCertificationDto>>(entities);
            return ServiceResponse<List<SupplierCertificationDto>>.ReturnResultWith200(entitiesDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while getting SupplierCertification");
            return ServiceResponse<List<SupplierCertificationDto>>.Return500("Error while getting SupplierCertification");
        }
    }
}
