﻿using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class AddSupplierContactCommandHandler(
   ISupplierContactRepository supplierContactRepository,
   ISupplierRepository supplierRepository,
   IMapper _mapper,
   IUnitOfWork<QMSDbContext> _uow,
   ILogger<AddSupplierContactCommandHandler> _logger) : IRequestHandler<AddSupplierContactCommand, ServiceResponse<SupplierContactDto>>
{
    public async Task<ServiceResponse<SupplierContactDto>> Handle(AddSupplierContactCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var supplier = await supplierRepository.FindAsync(request.SupplierId);
            if (supplier == null)
            {
                return ServiceResponse<SupplierContactDto>.Return404();
            }
            var existEntity = await supplierContactRepository.All
            .Where(c => c.Name == request.Name)
            .FirstOrDefaultAsync();
            if (existEntity != null)
            {
                return ServiceResponse<SupplierContactDto>.Return409("SupplierContact already exists.");
            }
            var entity = _mapper.Map<SupplierContact>(request);
            supplierContactRepository.Add(entity);
            if (await _uow.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<SupplierContactDto>.Return500();
            }
            var entityDto = _mapper.Map<SupplierContactDto>(entity);
            return ServiceResponse<SupplierContactDto>.ReturnResultWith201(entityDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Erorr while saving SupplierContact");
            return ServiceResponse<SupplierContactDto>.Return500("Error while Saving SupplierContact");
        }
    }
}
